unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMACMDlg, MMDSPObj, MMWavIn;

type
  TForm1 = class(TForm)
    ACM: TMMACM;
    btnSelect: TButton;
    btnSave: TButton;
    btnRestore: TButton;
    Label1: TLabel;
    lblFormat: TLabel;
    WaveIn: TMMWaveIn;
    procedure btnSelectClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRestoreClick(Sender: TObject);
  private
    procedure UpdateFormatString;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// This demo shows you how to select, save and restore a ACM WaveFormat

{------------------------------------------------------------------------------}
procedure TForm1.UpdateFormatString;
var
   sFormat,sFormatTag: string;
begin
   if acmGetFormatDescription(WaveIn.PWaveFormat,sFormatTag,sFormat) then
      lblFormat.Caption := sFormatTag+' - '+sFormat
   else
      lblFormat.Caption := 'Unknown Format';
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   UpdateFormatString;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnSelectClick(Sender: TObject);
begin
   if ACM.ChooseFormat(WaveIn.PWaveFormat,'Select Format...') then
   begin
      WaveIn.PWaveFormat := ACM.PWaveFormat;
      UpdateFormatString;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnSaveClick(Sender: TObject);
begin
   acmSaveFormatToRegistry(WaveIn.PWaveFormat,
                           HKEY_CURRENT_USER,
                           'Software\Swiftsoft\Formats',
                           'WaveFormat');
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnRestoreClick(Sender: TObject);
begin
   WaveIn.PWaveFormat := acmGetFormatFromRegistry(HKEY_CURRENT_USER,
                                                  'Software\Swiftsoft\Formats',
                                                  'WaveFormat');
   UpdateFormatString;
end;

end.
